#!/usr/local/bin/wish

set Script [info script]
set PhotoramaDir [file dirname $Script]

set f [open "$PhotoramaDir/PhotoramaPatron.html" "r"]
set TextePhotorama [read -nonewline $f]
close $f

set InitDir ""
set  PhotoramaLog "$PhotoramaDir/Photorama.log"
if {[file exists $PhotoramaLog]} {
    set f [open $PhotoramaLog "r"]
    set LesLignes [split [read -nonewline $f] "\n"]
    set InitDir [lindex $LesLignes end]
    close $f    
}
if {$InitDir==""} {
    foreach Disk [list s f] {
    set InitDir "Disk:/Phototheque"
	if {[file exists "Disk:/Phototheque"]} {
	    break
	}
	set InitDir ""
    }
}

set Rep [tk_chooseDirectory -initialdir $InitDir]

set NouveauNom "Photorama.html"

set I 1
set NouveauFichier "$Rep/$NouveauNom"
while {[file exists $NouveauFichier]} {
    incr I
    regsub {[0-9]*\.html$} $NouveauNom "[format "%2.2d" $I].html" NouveauNom
    set NouveauFichier "$Rep/$NouveauNom"
}

set LesImages {}
foreach Fichier [glob -nocomplain $Rep/*] {
    set Nom [file tail $Fichier]
    if { ! [regexp -nocase "\.jpg" $Nom]} { continue }
    lappend LesImages "\"$Nom\""
}


set TexteImages [join $LesImages ",\n"]

regsub "put here the list of the image files" $TextePhotorama $TexteImages NouveauPhotorama

set f [open "$Rep/Photorama.html" "w"]
puts $f $NouveauPhotorama
close $f

catch {
    set f [open $PhotoramaLog "w"]
    puts $f $Rep
    close $f
}

exit


